package gov.va.med.mhv.phr.chemlabs.decorator;

import org.apache.commons.lang.StringEscapeUtils;
import org.displaytag.decorator.TableDecorator;
import org.apache.commons.lang.StringUtils;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.phr.transfer.ChemLabsTest;

public class ChemLabsTestTableDecorator extends TableDecorator {

    protected static final String UNKNOWN = 
        StringEscapeUtils.escapeHtml("Unknown");
    protected static final String AMENDED = 
        StringEscapeUtils.escapeHtml("Amended");
	
    private ChemLabsTest getChemLabsTest() {
        Object currentRowObject = getCurrentRowObject();
        Precondition.assertAssignableFrom("currentRowObject", currentRowObject,
        		ChemLabsTest.class);
        ChemLabsTest result = (ChemLabsTest) currentRowObject;
        Precondition.assertNotNull("currentRowObject", result);
        return result;
    }
	
	public String getLabTestName() {
		if(getChemLabsTest()!=null && (!StringUtils.isEmpty(getChemLabsTest().getLabTestName()))){
			return getChemLabsTest().getLabTestName().trim();
		}else{
			return UNKNOWN;
		}	
	}
	
	
	public String getResult() {
		  ChemLabsTest obj = getChemLabsTest();
		  String value = "";
		  if (obj != null) {
		   if (!StringUtils.isEmpty(obj.getResults())) {
		    value += obj.getResults() + " ";
		   }
		   if (!StringUtils.isEmpty(obj.getResultIndicator())) {
		    value += obj.getResultIndicator();
		   }
		   return value;
		  }
		  return "";
	}	
	
	public String getReferenceRange() {
		if(getChemLabsTest()!=null && (!StringUtils.isEmpty(getChemLabsTest().getReferenceRange()))){
			return getChemLabsTest().getReferenceRange().trim();
		}else{
			return "";
		}
	}	
	
	public String getUnits() {
		if(getChemLabsTest()!=null && null != getChemLabsTest().getUnits()){
			return getChemLabsTest().getUnits().trim();
		}else{
			return "";
		}	
	}	
	
	public String getPerformingLocation() {
		if(getChemLabsTest()!=null && null != getChemLabsTest().getPerformingLocation()){
			return getChemLabsTest().getPerformingLocation().trim();
		}else{
			return UNKNOWN;
		}	
	}
	
	public String getStatus() {
		if(getChemLabsTest()!=null && null != getChemLabsTest().getStatus()){
			return getChemLabsTest().getStatus().trim();
		}else{
			return UNKNOWN;
		}	
	}
	
	public String getStatusCheck() {
		if(getChemLabsTest()!=null && null != getChemLabsTest().getStatus()){
			if(getChemLabsTest().getStatus().equalsIgnoreCase("Amended")){
				String spanStartValue = "&lt;span title=&quot;Test results changed after available to provider.&quot;&gt; ";
				String spanEndValue = "&lt;/span&gt;";
				String finalStatusValue = spanStartValue + AMENDED + spanEndValue; 
				return StringEscapeUtils.unescapeHtml(finalStatusValue);				
			}else{
				return "";
			}
		}else{
			return "";
		}	
	}	
	
	public String getInterpretation() {
		if(getChemLabsTest()!=null && null != getChemLabsTest().getInterpretation()){
			return getChemLabsTest().getInterpretation();
		}else{
			return "";
		}	
	}
	
	public String getDetails() {
		if(getChemLabsTest()!=null){
			return "Details";
		}else{
			return "";
		}	
	}	

}
